<?php

namespace Rubicore\AlingsasIntranet;

use \WP_REST_Request, \WP_User;

final class Post_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes(): void
	{
		$api = new \Rubicore\Core\Api_Helper('rubicore/alingsas-intranet/v1');

		$api->add_route('post/send-old-post-reminder', 'POST', function (WP_REST_Request $req, WP_User $user): void {
			\Rubicore\Core\User_Helper::allowed_to('akp_old_post_reminder', $user);

			$post_table = \Rubicore\Core\Db_Helper::table('posts');
			$user_table = \Rubicore\Core\Db_Helper::table('users');

			$new_date_unix = strtotime('-1 year', strtotime(\Rubicore\Core\Date_Helper::gmt_now(2)));
			$new_date = gmdate("Y-m-d H:i:s", $new_date_unix);

			$posts = \Rubicore\Core\Db_Helper::get_rows("
				SELECT
					p.post_title AS title,
					p.post_name AS slug,
					u.user_email AS email
				FROM {$post_table} AS p
				INNER JOIN {$user_table} AS u
				ON u.ID = p.post_author
				WHERE p.post_status = 'publish'
				AND p.post_type IN ('page', 'page-related')
				AND p.post_modified < %s
			", [$new_date]);

			foreach ($posts as $post) {
				$this->send_reminder($post);
			}
		});
	}


	private function send_reminder(object $post) : void
	{
		$email = [$post->email];
		$title = "Du har inaktuellt innehåll på Kommunportalen";

		$body = \Rubicore\Mail\Template_Helper::render('base', $this->template_dir, [
			'title' => $title,
			'cards' => [
				'title' => "Inaktuellt innehåll på: {$post->title}",
				'text' => "Sidan har inte uppdaterats på över ett år.",
				'buttonUrl' => "{$this->base_url}/sida/{$post->slug}",
				'buttonText' => 'TILL SIDA'
			]
		]);

		\Rubicore\Mail\Mail_Helper::send_mail($email, $title, $body);
	}
}
