<?php

namespace Rubicore\AlingsasIntranet;

final class Mail_Controller {

	private $template_dir = RUBICORE_ALINGSASINTRANET_ROOT_DIR . '/mail-templates';
	private $base_url = 'https://prd-intranet01.alingsas.se';

	function __construct()
	{
		$this->hooks();
	}


	private function hooks() : void
	{
		add_action('rubicore_core_course_approved', function (array $data): void {
			$post = \Rubicore\Core\Post_Service::get_by_slug($data['post_id'], 'course');
			$user = \Rubicore\Core\User_Service::get_by_identifier($data['user_id']);

			$email = [$user->email];
			$filename = '';

			if ($post->media && $post->media->filename) {
				$filename = $post->media->filename;
			}

			$body = \Rubicore\Mail\Template_Helper::render('base', $this->template_dir, [
				'title' => "Antagen till kurs: $post->title",
				'cards' => [
					'title' => "Du har blivit antagen till {$post->title}",
					'text' => $post->excerpt,
					'imageUrl' => $filename ? "{$this->base_url}/wp-content/uploads/{$filename}" : '',
					'buttonUrl' => "{$this->base_url}/kurs/{$post->slug}",
					'buttonText' => 'TILL KURSSIDA'
				]
			]);

			\Rubicore\Mail\Mail_Helper::send_mail($email, "Antagen på kurs: $post->title", $body);
		});


		add_action('rubicore_core_user_update', function (array $data) : void {
			$user_id = $data['user_id'];
			$data_to_update = $data['data'];

			$user = \Rubicore\Core\User_Service::get_by_identifier($user_id);

			if ($data_to_update->description == $user->meta->description) {
				return;
			}

			$email = ['vaxeln@alingsas.se'];
			$filename = $user->meta->avatar;

			$body = \Rubicore\Mail\Template_Helper::render('base', $this->template_dir, [
				'title' => "Ändring av rollbeskrivning",
				'cards' => [
					'title' => "Ändring av rollbeskrivning: {$user->name}",
					'text' => $data_to_update->description,
					'imageUrl' => $filename ? "{$this->base_url}/wp-content/uploads/{$filename}" : ''
				]
			]);

			\Rubicore\Mail\Mail_Helper::send_mail($email, "Ändring av rollbeskrivning: {$user->name}", $body);
		});


		add_action('rubicore_core_comment_post', function (array $data) : void {
			$post = \Rubicore\Core\Post_Service::get_by_slug($data['post_id'], null);
			$user = \Rubicore\Core\User_Service::get_by_identifier($data['user_id']);
			$comment_text = $data['comment'];

			$email = [$post->author->email];
			$filename = '';
			$title = "Ny kommentar på: $post->title";

			if ($post->media && $post->media->filename) {
				$filename = $post->media->filename;
			}

			$body = \Rubicore\Mail\Template_Helper::render('base', $this->template_dir, [
				'title' => $title,
				'cards' => [
					'title' => $title,
					'text' => "{$comment_text} - {$user->name}",
					'imageUrl' => $filename ? "{$this->base_url}/wp-content/uploads/{$filename}" : ''
				]
			]);

			\Rubicore\Mail\Mail_Helper::send_mail($email, $title, $body);

		});
	}
}
