<?php

namespace Rubicore\AlingsasIntranet;

use \WP_REST_Request, \WP_User;

final class Job_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes(): void
	{
		$api = new \Rubicore\Core\Api_Helper('rubicore/alingsas-intranet/v1');

		$api->add_route('job', 'GET', function (WP_REST_Request $req, WP_User $user): object {
			$job_repo = new Job_Repository();

			return $job_repo->list();
		});

		$api->add_route('job/(?P<guid>[^/]+?)', 'GET', function (WP_REST_Request $req, WP_User $user): object {
			$job_repo = new Job_Repository();

			return $job_repo->get($req->get_param('guid'));
		});
	}
}
