<?php if (!defined('ABSPATH')) {
	exit;
}

/*
Plugin Name: Rubicore Alingsås Intranät
Plugin URI:
Description: Rubicore plugin for Alingsås municipality intranet.
Version: 0.1.0
Author: Knowe AB
Author URI: https://knowe.se
Text Domain: Rubicore
*/


function RUBICORE_AlingsasIntranet_check_dependencies(): void
{
	if (!is_plugin_active('rubicore-core/rubicore-core.php') && current_user_can('activate_plugins')) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die('Sorry, but Rubicore Alingsås Intranet plugin requires the Rubicore Core plugin to be installed and active. <br><a href="' . admin_url('plugins.php') . '">&laquo; Return to Plugins</a>');
	}
}

register_activation_hook(__FILE__, 'RUBICORE_AlingsasIntranet_check_dependencies');

define('RUBICORE_ALINGSASINTRANET_ROOT_DIR', WP_PLUGIN_DIR . '/rubicore-alingsas-intranet');

add_action('rubicore_init', function () {
	Rubicore\Core\Autoloader::register_autoloader(RUBICORE_ALINGSASINTRANET_ROOT_DIR, 'Rubicore\\AlingsasIntranet\\');

	new Rubicore\AlingsasIntranet\User_Controller();
});


add_action('admin_init', function () {
	RUBICORE_AlingsasIntranet_check_dependencies();
});
