<?php

namespace Rubicore\AlingsasIntranet;

use \Rubicore\Core\Db_Helper;

final class User_Repository {
	private string $user_table;
	private string $user_link_table;
	private string $user_node_table;
	private string $link_node_table;
	private string $link_table;

	function __construct()
	{
		$this->user_table = Db_Helper::table('users');
		$this->link_table = Db_Helper::table('link');
		$this->user_link_table = Db_Helper::table('user_link');
		$this->user_node_table = Db_Helper::table('user_node');
		$this->link_node_table = Db_Helper::table('link_node');
	}

	public function sync_user_tools() : void
	{
		$users = Db_Helper::get_rows("SELECT * FROM {$this->user_table} AS u");

		foreach ($users as $user) {
			$user->nodes = Db_Helper::get_rows("
				SELECT * FROM {$this->user_node_table} AS un
				WHERE un.user_id = %d
			", [$user->ID]);
		}

		$links = Db_Helper::get_rows("
			SELECT * FROM {$this->link_table} AS l
			WHERE l.type = 'tool'
			AND l.public = true
		");

		foreach ($links as $link) {
			$link->nodes = Db_Helper::get_rows("
				SELECT * FROM {$this->link_node_table} AS ln
				WHERE ln.link_id = %d
			", [$link->id]);
		}

		foreach ($users as $user) {
			foreach ($links as $link) {
				if (count($link->nodes) == 0) {
					continue;
				}

				foreach($user->nodes as $userNode) {
					if (array_search($userNode->node_id, array_column($link->nodes, 'node_id')) !== false) {
						$this->add_user_link($user->ID, $link->id);
						break;
					}
				}
			}
		}
	}


	private function add_user_link(int $user_id, int $link_id) : void
	{
		$row = Db_Helper::get_row("
			SELECT * FROM {$this->user_link_table} AS ul
			WHERE ul.user_id = %d
			AND ul.link_id = %d
		", [$user_id, $link_id]);

		if ($row) {
			return;
		}

		Db_Helper::insert('user_link', [
			'user_id' => $user_id,
			'link_id' => $link_id
		], ['%d', '%d']);
	}

}
