<?php if (!defined('ABSPATH')) {
	exit;
}

/*
Plugin Name: Rubicore Alfresco
Plugin URI:
Description: Alfresco plugin for Rubicore framework. This plugin is made specific for Alingsås Kommun.
Version: 0.0.2
Author: Knowe AB
Author URI: https://knowe.se
Text Domain: Rubicore
*/


function RUBICORE_Alfresco_check_dependencies(): void
{
	if (!is_plugin_active('rubicore-core/rubicore-core.php') && current_user_can('activate_plugins')) {
		deactivate_plugins(plugin_basename(__FILE__, true));
		wp_die('Sorry, but Rubicore Alfresco plugin requires the Rubicore Core plugin to be installed and active. <br><a href="' . admin_url('plugins.php') . '">&laquo; Return to Plugins</a>');
	}
}

register_activation_hook(__FILE__, 'RUBICORE_Alfresco_check_dependencies');

define('RUBICORE_ALFRESCO_ROOT_DIR', WP_PLUGIN_DIR . '/rubicore-alfresco');

add_action('rubicore_init', function () {
	Rubicore\Core\Autoloader::register_autoloader(RUBICORE_ALFRESCO_ROOT_DIR, 'Rubicore\\Alfresco\\');

	new Rubicore\Alfresco\Site_Controller();
	new Rubicore\Alfresco\Favorite_Controller();
	new Rubicore\Alfresco\Token_Controller();
	new Rubicore\Alfresco\Node_Controller();
});


add_action('admin_init', function () {
	RUBICORE_Alfresco_check_dependencies();
});
