<?php

namespace Rubicore\Alfresco;

final class Site_Repository {

	public function get(string $token, $uid) : array {
		$sites = Request_Helper::get("people/{$uid}/sites", array(
			'body' => [],
			'query' => array(
				'maxItems' => 999
				//'fields' => 'title,guid,id,description,visibility,role'
			),
			'token' => $token
		));

		$favorites = Request_Helper::get("people/{$uid}/favorites", array(
			'body' => [],
			'query' => array(
				'maxItems' => 999,
				'where' => '(EXISTS(target/site))'
				//'fields' => 'title,guid,id,description,visibility,role'
			),
			'token' => $token
		));

		$favorites_guids = [];
		
		foreach($favorites['list']['entries'] as $entry) {
			$favorites_guids[$entry['entry']['targetGuid']] = true;
		}

		$sites = array_map(function($entry) use($favorites_guids, $token) {
			$val = $entry['entry']['site'];
			$val['isFavorite'] = array_key_exists($val['guid'], $favorites_guids);

			
			$val['documentLibraryGuid'] = $this->get_document_library_id($token, $val['guid']);

			return $val;
		}, $sites['list']['entries']);

		return $sites;
	}

	private function get_document_library_id(string $token, string $guid) : ?string {
		$nodes = Request_Helper::get("nodes/{$guid}/children", array(
			'body' => [],
			'query' => array(
				'maxItems' => 999,
				'fields' => 'id,name'
			),
			'token' => $token
		));

		$ret = null;

		foreach ($nodes['list']['entries'] as $entry) {
			if ($entry['entry']['name'] == 'documentLibrary') {
				$ret = $entry['entry']['id'];
			}
		}

		return $ret;
	}
}