<?php

namespace Rubicore\Alfresco;

use \Rubicore\Core\Format_Helper;
use \Rubicore\Core\Response_Helper;

final class Node_Repository
{

	public function get(string $token, string $guid) : array
	{
		$nodes = Request_Helper::get("nodes/{$guid}/children", array(
			'body' => [],
			'query' => array(
				'maxItems' => 999,
				'fields' => 'id,isFile,isFolder,name,parentId'
			),
			'token' => $token
		));

		$nodes = array_map(function ($entry) {
			$val = $entry['entry'];
	
			return $val;
		}, $nodes['list']['entries']);

		return $nodes;
	}

	public function upload(string $token, string $guid, $file, $content_type)
	{

		$ext = 'txt';
		$uploads_dir = 'wp-content/uploads/';
		$uuid = Format_Helper::create_uuid();
		$filename = "TMP_{$uuid}.{$ext}";
		$full_path = "{$uploads_dir}{$filename}";

		if (!file_put_contents($full_path, $file)) {
			Response_Helper::die('Unable to save file content to disk.', 500);
		}

		$body = [
			'filedata' => curl_file_create(
				$full_path,
				$content_type['value'],
				$filename
			),
			'name' => 'My test.txt',
			'nodeType' => 'cm:content',
			'cm:title' => 'My test',
			'cm:description' => 'My text document description',
			'relativePath' => 'Test',
			'autoRename' => true
		];

		$headers = [
			'Content-Type: multipart/form-data',
			'Authorization: Basic ' . base64_encode($token)
		];

		$curl_handle = curl_init();
		curl_setopt($curl_handle, CURLOPT_URL, "https://alfresco.alingsas.se/alfresco/api/-default-/public/alfresco/versions/1/nodes/{$guid}/children");
		curl_setopt($curl_handle, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($curl_handle, CURLOPT_POST, TRUE);
		curl_setopt($curl_handle, CURLOPT_POSTFIELDS, $body);
		curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, TRUE);
		$response = curl_exec($curl_handle);

		if (curl_errno($curl_handle)) {
			$error_msg = curl_error($curl_handle);
			Response_Helper::die($error_msg);
		}

		curl_close($curl_handle);
		wp_delete_file($full_path);

		$body = json_decode($response['body'], true);

		if (array_key_exists('error', $body)) {
			Response_Helper::die($body['error']['briefSummary'], $body['error']['statusCode']);
		}
	
		return json_decode($body);
	}
}
