<?php

namespace Rubicore\Alfresco;

use \WP_REST_Request, \WP_User;
use \Rubicore\Core\Api_Helper;

final class Token_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes() : void
	{
		$api = new Api_Helper('rubicore/alfresco/v1');

		$api->add_route('token', 'POST', function (WP_REST_Request $req, WP_User $user) : void {
			$token_repo = new Token_Repository();
			$body = array(
				'userId' => $req->get_param('userId') ? $req->get_param('userId') : $user->get('login'),
				'password' => $req->get_param('password')
			);

			$token = $token_repo->get($body);

			update_user_meta($user->ID, 'alfresco_token', $token['id']);
		}, array(
			'args' => array(
				'userId' => array('type' => Api_Helper::TYPE_STRING, 'required' => false, 'minLength' => 1),
				'password' => array('type' => Api_Helper::TYPE_STRING, 'required' => true, 'minLength' => 1)
			)
		));
	}
}
