<?php

namespace Rubicore\Alfresco;

use \WP_REST_Request, \WP_User;
use \Rubicore\Core\Api_Helper;

final class Site_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes(): void
	{
		$api = new Api_Helper('rubicore/alfresco/v1');

		$api->add_route('site', 'GET', function (WP_REST_Request $req, WP_User $user) {
			$site_repo = new Site_Repository();
			$token = Token_Helper::get_token($user);

			return $site_repo->get($token, $user->get('user_login'));
		});
	}
}
