<?php

namespace Rubicore\Alfresco;

use \WP_REST_Request, \WP_User;
use \Rubicore\Core\Api_Helper;

final class Node_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes(): void
	{
		$api = new Api_Helper('rubicore/alfresco/v1');

		$api->add_route('node/(?P<guid>[a-zA-Z0-9-]+)', 'GET', function (WP_REST_Request $req, WP_User $user) {
			$node_repo = new Node_Repository();
			$token = Token_Helper::get_token($user);

			return $node_repo->get($token, $req->get_param('guid'));
		}, [
			'args' => [
				'guid' => ['type' => Api_Helper::TYPE_STRING, 'in' => Api_Helper::IN_PATH]
			]
		]);

		$api->add_route('node/(?P<guid>[a-zA-Z0-9-]+)', 'POST', function (WP_REST_Request $req, WP_User $user) {
			$node_repo = new Node_Repository();
			$token = Token_Helper::get_token($user);
			$file = $req->get_body();
			$content_type = $req->get_content_type();

			return $node_repo->upload($token, $req->get_param('guid'), $file, $content_type);
		}, [
			'args' => [
				'guid' => ['type' => Api_Helper::TYPE_STRING, 'in' => Api_Helper::IN_PATH]
			]
		]);
	}
}
