<?php

namespace Rubicore\Alfresco;

use \WP_REST_Request, \WP_User;
use \Rubicore\Core\Api_Helper;

final class Favorite_Controller
{

	function __construct()
	{
		$this->routes();
	}

	private function routes(): void
	{
		$api = new Api_Helper('rubicore/alfresco/v1');

		$api->add_route('favorite', 'POST', function (WP_REST_Request $req, WP_User $user) : void {
			$favorite_repo = new Favorite_Repository();
			$token = Token_Helper::get_token($user);

			$favorite_repo->add($token, $user->get('user_login'), $req->get_param('guid'));
		}, [
			'args' => [
				'guid' => ['type' => Api_Helper::TYPE_STRING, 'in' => Api_Helper::IN_BODY]
			]
		]);

		$api->add_route('favorite/(?P<guid>[a-zA-Z0-9-]+)', 'DELETE', function (WP_REST_Request $req, WP_User $user) : void {
			$favorite_repo = new Favorite_Repository();
			$token = Token_Helper::get_token($user);

			$favorite_repo->remove($token, $user->get('user_login'), $req->get_param('guid'));
		},
			[
				'args' => [
					'guid' => ['type' => Api_Helper::TYPE_STRING, 'in' => Api_Helper::IN_PATH]
				]
			]
		);
	}
}
