
import { h, Component, render } from 'https://unpkg.com/preact?module';
import htm from 'https://unpkg.com/htm?module';

// Initialize htm with Preact
const html = htm.bind(h);

if (window._ENDORFIN_SUPPLIES) {

	var data = window._ENDORFIN_SUPPLIES.filter((supply) => supply.terms !== false);

	const sorterdArray = data.sort((a,b) => (a.terms[0].slug > b.terms[0].slug) ? 1 : ((b.terms[0].slug > a.terms[0].slug) ? -1 : 0));



	const terms = sorterdArray.reduce((acc, curr) => {
		curr.terms.forEach(term => {
			if (!acc.some(item => item.term_id === term.term_id)) {
				acc.push(term);
			}

		});

		return acc;
	}, []);


	function App () {
		return html`
			<div >
				<${Accordion}/>
			</div>
		`;
	}

	class Accordion extends Component {
		state = {
			isActiveIndex: null,
			activeTerm: terms
		}

		handleClick = (index) => {
			this.setState(() => ({
				isActiveIndex: index
			}))
		}

		onFilterClick = (term) => {
			this.setState(() => ({ activeTerm: term}))
		}

		scrollTo()  {
			if(window.innerWidth < 500) 
				location.href = "#scrollTo"
		}

		filterItems = data => {
			const sortedItems = data.sort((a,b) => (a.terms.title > b.title) ? 1 : ((b.title > a.title) ? -1 : 0));

			return this.state.activeTerm ? sortedItems.filter(item => {
				return item.terms.some(term => term.term_id === this.state.activeTerm.term_id);
			}) : data;

		}

		render() {
				return html`
					<div>
						<div onClick=${this.scrollTo()}  class="Endorfin-CategoryFilter">
						${terms.map((term, i) => {
							return html`
								<div class="Endorfin-CategoryFilter-item ${term.term_id === this.state.activeTerm.term_id ? 'Endorfin-CategoryFilter-item--active' : ''}" onClick=${() => this.onFilterClick(term)}>
									<img class='Endorfin-CategoryFilter-image' src="/wp-content/uploads/supply_${term.slug}.jpg"/>
									<div class="Endorfin-CategoryFilter-itemLabel">${term.name}</div>
								</div>
								`
						})}
						</div>
						<h2 class="Endorfin-CategoryFilter-Header">${this.state.activeTerm.name}</h2>

					</div>
					${this.filterItems(sorterdArray).map((supply, i) => {
						return html`
							<div onClick=${() => this.handleClick(this.state.isActiveIndex === i ?  null : i) } class=${this.state.isActiveIndex === i ? 'Endorfin-Accordion-Header-Open' : 'Endorfin-Accordion-Header-Closed'}>
								<div id='scrollTo' class='Endorfin-Accordion-HeaderTitle'>${supply.title}
									${this.state.isActiveIndex === i ?
										html`<span class='et-pb-icon' style='font-size: 23px; color: #512D79; '>2</span>`
										: html`<span class='et-pb-icon' style='font-size: 23px; color: white;'>3</span>`}
								</div>
								${this.state.isActiveIndex === i ? html`<${AccordionBody } data=${supply} />` : ''}
							</div>
							`
					})}
				`;
			}
		}

		function AccordionBody(props) {
			return (html`
				<div class='Endorfin-Accordion-Body'>
					<div class='Endorfin-AccordionImageContainer'>
						<img src=${props.data.image} />
					</div>
					<div class="Endorfin-AccordionExcerpt">
					${props.data.time ? html`
						<div class='Endorfin-AccordionTime'>
							<span style='font-size: 23px; padding-right: 12px; color: #8BC11F;' class='et-pb-icon'>;</span>
							<div>${props.data.time} MIN </div>
						</div>` : ''}
						<${Excerpt} excerpt=${props.data.excerpt} />
					</div>
				</div>

				<div class='Endorfin-ProgressContainer'>
					${props.data.condition ? html `
					<div class="Endorfin-Progress">
						<div class="Endorfin-ProgressLabel">Kondition</div>
						<${ProgressBar} progress=${props.data.condition}/>
					</div>` : ''}

					${props.data.strength ? html `
					<div class="Endorfin-Progress">
						<div class="Endorfin-ProgressLabel">Styrka</div>
						<${ProgressBar} progress=${props.data.strength}/>
					</div>` : ''}

					${props.data.balance ? html `
					<div class="Endorfin-Progress">
						<div class="Endorfin-ProgressLabel">Balans</div>
						<${ProgressBar} progress=${props.data.balance}/>
					</div>` : ''}

					${props.data.choreography ? html `
					<div class="Endorfin-Progress">
						<div class="Endorfin-ProgressLabel">Koreografi</div>
						<${ProgressBar} progress=${props.data.choreography}/>
					</div>` : ''}

					${props.data.intensity ? html`
					<div class="Endorfin-Progress">
						<div class="Endorfin-ProgressLabel">Intensitet</div>
						<${ProgressBar} progress=${props.data.intensity}/>
					</div>` : ''}

					${props.data.mobility ? html`
					<div class="Endorfin-Progress">
						<div class="Endorfin-ProgressLabel">Rörlighet</div>
						<${ProgressBar} progress=${props.data.mobility}/>
					</div>` : ''}

				</div>
				<div class='Endorfin-AccordionButtons'>
					<${Buttons} buttons=${props.data.custom_buttons}/>
				</div>
			`)
		}

		const Excerpt = ({ excerpt }) => {
			const excerptWithLineBreaks = { __html: excerpt.replace(/\n/g, '<br>') };
			return html`<div class='Endorfin-AccordionImageExcerpt' dangerouslySetInnerHTML=${excerptWithLineBreaks} />`;
		}

		function ProgressBar(props) {
			const p = Number(props.progress);

			return html`<div class="Endorfin-ProgressBar">
				<div class="Endorfin-ProgressBar-item ${p >= 1 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
				<div class="Endorfin-ProgressBar-item ${p >= 2 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
				<div class="Endorfin-ProgressBar-item ${p >= 3 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
				<div class="Endorfin-ProgressBar-item ${p >= 4 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
			</div>`;
		}

		function Buttons(props) {
			const colors = ["#8BC11F", "#512D79", "#CB6898"];
			const buttons = props.buttons ? props.buttons.filter(x => x.label !== '') : [];

			return html` ${buttons.map((button, index) => {
				const colorIndex = index % 3;
				return html`<button onclick=${() => window.open(`${button.url}`)} style="background-color:${colors[colorIndex]}" class='Endorfin-Accordion-Button'>${button.label} </button>`
			})}`
		}


	render(html`<${App}/>`, document.getElementById('Endorfin-Supplies'));
}

