import { deviceHelper } from "../../helpers/scripts/device_helper.js";

export const deviceAdapter = {

    scrollToAnchorActive() {
        var href = location.href;
        var scrollToAnchorActive = href.includes("#scrollTo");
    
        return scrollToAnchorActive;
    },
    
    preventPageLoadScrollOnSmallerDevices() {
        if (!deviceHelper.isSmallerScreen())
            return;
    
        this.removeTagFromUrl("#pageLoadScrollTo");
        this.removeTagFromUrl("#scrollTo");
    },
    
    removeTagFromUrl(tag) {
        var href = location.href;

        if(!href.includes(tag))
            return;

        href = href.replace(tag, "");
        var slashSplit = href.split("/");
        slashSplit.splice(0, 3);
        var path = this.buildPathFromSlashSplit(slashSplit);
        history.replaceState({}, null, path);
    },

    buildPathFromSlashSplit(slashSplit) {
        var path = "";
    
        slashSplit.forEach(pathPart => {
            path += `/${pathPart}`;
        });
    
        return path;
    },

    widenMembershipCardsOnSmallerDevices() {
        if (!deviceHelper.isSmallerScreen())
            return;

        this.widenMembershipCards();
    },

    widenMembershipCards()
    {
        var etPbRow = this.getMembershipsEtPbRow();
        etPbRow.style.width = "95%";
        etPbRow.style.paddingLeft = "0px";
        etPbRow.style.paddingRight = "0px";

        var etCode = this.getMembershipsEtCode();
        etCode.style.paddingLeft = "0px";

        const cards = this.getMembershipCards();
        cards.forEach(card => {
            card.style.width = "100%";
        });
    },

    getMembershipCardBodies() {
        var cardBodyCollection = document.getElementsByClassName("Endorfin-Membership-Excerpt");
        var cardBodies = [...cardBodyCollection];

        return cardBodies;
    },

    getMembershipCards() {
        const membershipCardCollection = document.getElementsByClassName("Endorfin-Membership");
        const cards = [...membershipCardCollection];

        return cards;
    },

    getFirstMembershipCard() {
        const cards = this.getMembershipCards();
        const firstCard = cards[0];

        return firstCard;
    },

    getMembershipsEtPbRow() {
        var firstCard = this.getFirstMembershipCard();
        var pbRow = this.findParentWithClass(firstCard, "et_pb_row");

        return pbRow;
    },

    findParentWithClass(element, className) {
        let parent = element.parentNode;

        while (parent) {
            if (parent.classList.contains(className))
                return parent;

            parent = parent.parentNode;
        }

        return null;
    },

    getMembershipsEtCode() {
        var firstCard = this.getFirstMembershipCard();
        var etCode = this.findParentWithClass(firstCard, "et_pb_code_0");

        return etCode;
    },

    pageLoadScrollOnDesktop() {
        if(!deviceHelper.isLargeScreen())
            return;
    
        this.addScrollToTagToUrl();
    },
    
    addScrollToTagToUrl() {
        location.hash = "#pageLoadScrollTo";
    },

    goToTopOnSmallerDevice() {
        if(!deviceHelper.isSmallerScreen())
            return;

        window.scrollTo(0, 0);
    }

};