import { h, Component, render } from 'https://unpkg.com/preact?module';
import htm from 'https://unpkg.com/htm?module';

const html = htm.bind(h);

if (window._SUPPLIES_DATA) {

    class DynamicAccordion extends Component {

        state = {
            isActiveIndex: null
        }

        handleClick = (index) => {
            this.setState(() => ({
                isActiveIndex: index
            }));
        }

        render(props) {
            var categoryId = props.categoryId;
            var facilityId = props.facilityId;

            var supplies = this.getSupplies(categoryId, facilityId);

            return html`
            <h2 class="Endorfin-CategoryFilter-Header">${props.title}</h2>
            ${supplies.map((supply, i) => {
                return html`
                    <div onClick=${() => this.handleClick(this.state.isActiveIndex === i ? null : i)} class=${this.state.isActiveIndex === i ? 'Endorfin-Accordion-Header-Open' : 'Endorfin-Accordion-Header-Closed'}>
                        <div class='Endorfin-Accordion-HeaderTitle'>${supply.title}
                            ${this.state.isActiveIndex === i ?
                        html`<span class='et-pb-icon' style='font-size: 23px; color: #512D79; '>2</span>`
                        : html`<span class='et-pb-icon' style='font-size: 23px; color: white;'>3</span>`}
                        </div>
                        ${this.state.isActiveIndex === i ? html`<${AccordionBody} data=${supply} />` : ''}
                    </div>
                    `
            })}
            `;
        }

        getSupplies(categoryId, facilityId) {
            var supplies = window._SUPPLIES_DATA;

            var soughtSupplies = [];
            for(var i=0; i<supplies.length; i++) {
                var supply = supplies[i];
                var supplyIsInCategory = this.supplyIsInCategory(supply, categoryId);
                var supplyIsInFacility = this.supplyIsInFacility(supply, facilityId);

                if(supplyIsInCategory && supplyIsInFacility)
                    soughtSupplies.push(supply);
            }

            return soughtSupplies;
        }

        supplyIsInCategory(supply, categoryId) {
            var categories = supply.terms;

            if(!categories)
                return false;

            for(var i=0; i<categories.length; i++) {
                var category = categories[i];

                if(category.term_id == categoryId)
                    return true;
            }

            return false;
        }

        supplyIsInFacility(supply, facilityId) {
            var facilities = supply.facilities;

            if(!facilities)
                return false;

            for(var i=0; i<facilities.length; i++) {
                var facility = facilities[i];

                if(facility.term_id == facilityId)
                    return true;
            }

            return false;
        }

        getCategory(categoryId) {
            var supplies = window._SUPPLIES_DATA;

            for (var i = 0; i < supplies.length; i++) {
                var supply = supplies[i];
                var supplyTerm = supply.terms[0];

                if(!supplyTerm)
                    continue;

                if (supplyTerm.term_id == categoryId)
                    return supplyTerm;
            }

            return null;
        }
    }

    function AccordionBody(props) {
        return (html`
            <div class='Endorfin-Accordion-Body'>
                <div class='Endorfin-AccordionImageContainer'>
                    <img src=${props.data.image} />
                </div>
                <div class="Endorfin-AccordionExcerpt">
                ${props.data.time ? html`
                    <div class='Endorfin-AccordionTime'>
                        <span style='font-size: 23px; padding-right: 12px; color: #8BC11F;' class='et-pb-icon'>;</span>
                        <div>${props.data.time} MIN </div>
                    </div>` : ''}
                    <${Excerpt} excerpt=${props.data.excerpt} />
                </div>
            </div>

            <div class='Endorfin-ProgressContainer'>
                ${props.data.condition ? html`
                <div class="Endorfin-Progress">
                    <div class="Endorfin-ProgressLabel">Kondition</div>
                    <${ProgressBar} progress=${props.data.condition}/>
                </div>` : ''}

                ${props.data.strength ? html`
                <div class="Endorfin-Progress">
                    <div class="Endorfin-ProgressLabel">Styrka</div>
                    <${ProgressBar} progress=${props.data.strength}/>
                </div>` : ''}

                ${props.data.balance ? html`
                <div class="Endorfin-Progress">
                    <div class="Endorfin-ProgressLabel">Balans</div>
                    <${ProgressBar} progress=${props.data.balance}/>
                </div>` : ''}

                ${props.data.choreography ? html`
                <div class="Endorfin-Progress">
                    <div class="Endorfin-ProgressLabel">Koreografi</div>
                    <${ProgressBar} progress=${props.data.choreography}/>
                </div>` : ''}
            </div>
            <div class='Endorfin-AccordionButtons'>
                <${Buttons} buttons=${props.data.custom_buttons}/>
            </div>
        `);
    }

    const Excerpt = ({ excerpt }) => {
        const excerptWithLineBreaks = { __html: excerpt.replace(/\n/g, '<br>') };
        return html`<div class='Endorfin-AccordionImageExcerpt' dangerouslySetInnerHTML=${excerptWithLineBreaks} />`;
    }

    function renderAccordion(accordion) {
        render(html`<${DynamicAccordion} 
            facility=${accordion.dataset.facility} 
            facilityId=${accordion.dataset.facilityid} 
            category=${accordion.dataset.category} 
            title=${accordion.dataset.title} 
            categoryId=${accordion.dataset.categoryid} 
            accordionId=${accordion.id} />`, document.getElementById(accordion.id));
    }

    function renderAccordions() {
        var supplyAccordions = document.getElementsByClassName("dynamic-supply-accordion");
        supplyAccordions = [...supplyAccordions];

        supplyAccordions.forEach(accordion => {
            renderAccordion(accordion);
        });
    }

    function ProgressBar(props) {
        const p = Number(props.progress);

        return html`<div class="Endorfin-ProgressBar">
            <div class="Endorfin-ProgressBar-item ${p >= 1 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
            <div class="Endorfin-ProgressBar-item ${p >= 2 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
            <div class="Endorfin-ProgressBar-item ${p >= 3 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
            <div class="Endorfin-ProgressBar-item ${p >= 4 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
        </div>`;
    }

    function Buttons(props) {
        const colors = ["#8BC11F", "#512D79", "#CB6898"];
        const buttons = props.buttons ? props.buttons.filter(x => x.label !== '') : [];

        return html` ${buttons.map((button, index) => {
            const colorIndex = index % 3;
            return html`<button onclick=${() => window.open(`${button.url}`)} style="background-color:${colors[colorIndex]}" class='Endorfin-Accordion-Button'>${button.label} </button>`
        })}`
    }

    renderAccordions();
}