function getSupplyCustomOptions() {
    var selectList = document.getElementById("metakeyselect");
    if(!selectList)
        return null;

    var optionTagsCollection = selectList.getElementsByTagName("option");
    var optionTags = [... optionTagsCollection];
    var supplyCustomOptions = [];

    var optionsToRemove = [
        "STYRKA",
        "KONDITION",
        "BALANS",
        "KOREOGRAFI",
        "TIME",
        "PRISTEXT"
    ];

    optionTags.forEach((optionTag) => {
        var optionValue = optionTag.value.toUpperCase();
        if(optionsToRemove.includes(optionValue))
            supplyCustomOptions.push(optionTag);
    });

    return supplyCustomOptions;
}

function removeSupplyCustomOptionsFromSelectList() {
    var options = getSupplyCustomOptions();
    if(!options)
        return;

    var selectList = document.getElementById("metakeyselect");

    options.forEach((option) => {
        selectList.removeChild(option);
    });
}

document.addEventListener("DOMContentLoaded", function(event) {
    removeSupplyCustomOptionsFromSelectList();
});