<?php

namespace EndorfinKnowe;

use \add_action, \register_post_types, \register_taxonomy, \add_shortcode, \add_meta_box;

final class Meta_Select_List_Customization
{
	function __construct()
	{
		$this->init();
	}

	private function init() : void 
	{
		$this->add_script_file();
		$this->add_style();
	}

	private function add_script_file() : void
	{
		wp_enqueue_script("endorfin-meta-select-list-customization-script", plugin_dir_url(__FILE__) . 'scripts/index.js', array(), '1.0.0');
	}

	private function add_style() : void
	{
		wp_enqueue_style('endorfin-meta-select-list-customization-styles', plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');
	}

}
