<?php

namespace EndorfinKnowe;

use \add_action, \add_filter;

final class Header_Customizations {

    function __construct() {
        $this->init();
    }

    private function init() {
        $this->enqueue_scripts();
    }

    private function enqueue_scripts() {
        add_action('wp_enqueue_scripts', function () {
			wp_enqueue_script('header-customizations-scripts', plugin_dir_url(__FILE__) . 'scripts/index.js', array(), '1.0.0', true);
		});

        add_filter('script_loader_tag', function ($tag, $handle, $src) {
			// if not your script, do nothing and return original $tag
			if ('header-customizations-scripts' !== $handle) {
				return $tag;
			}

			// change the script tag by adding type="module" and return it.
			$tag = '<script type="module" src="' . esc_url( $src ) . '"></script>';

			return $tag;
		} , 10, 3);
    }

}