
import { h, Component, render } from 'https://unpkg.com/preact?module';
import htm from 'https://unpkg.com/htm?module';

// Initialize htm with Preact
const html = htm.bind(h);
if (window._ENDORFIN_MEMBERSHIPS) {
	const jsondata = window._ENDORFIN_MEMBERSHIPS;
	const data = jsondata.data;
	const terms = getTerms();

	function App() {
		return html`
			<div >
				<${Accordion}/>
			</div>
		`;
	}

	class Accordion extends Component {
		state = {
			isActiveIndex: 0,
			activeTerm: terms[0]
		}

		handleClick = (index) => {
			this.setState(() => ({
				isActiveIndex: index
			}));
		}

		onFilterClick = (term) => {
			this.setState(() => ({ activeTerm: term }))
		}

		getFilteredItems = (data) => {
			var terms = getTerms();

			var activeTermTitle = this.state.activeTerm ? this.state.activeTerm.name : terms[0].name;

			var filteredMemberships = [];
			
			if(activeTermTitle.toUpperCase().includes("SENIOR"))
				filteredMemberships = getSeniorMemberships();
			else if(activeTermTitle.toUpperCase().includes("ORDINARIE"))
				filteredMemberships = getOrdinarieMemberships();
			else if(activeTermTitle.toUpperCase().includes("STUDERANDE"))
				filteredMemberships = getStuderandeMemberships();
			else if(activeTermTitle.toUpperCase().includes("UNGDOM"))
				filteredMemberships = getUngdomMemberships();
			else if(activeTermTitle.toUpperCase().includes("KLIPPKORT"))
				filteredMemberships = getKlippKortMemberships();
			else
				filteredMemberships = data;

			return filteredMemberships;
		}

		render() {
			return html`
					<div>
						<div id="pageLoadScrollTo" onClick=${scrollTo}  class="Endorfin-MembershipFilter">
						${getTerms().map((term, i) => {
							return html`
								<div class="Endorfin-MembershipCategoryFilter-item ${term.term_id === this.state.activeTerm.term_id ? 'Endorfin-MembershipCategoryFilter-item--active' : ''}" onClick=${() => this.onFilterClick(term)}>
									<div class="Endorfin-MembershipCategoryFilter-itemLabel">${term.name}</div>
								</div>
								`
			})}
						</div>
						<h2 id='scrollTo' class="Endorfin-MembershipFilter-Header">${this.state.activeTerm.name}</h2>

					</div>
									<div class='Endorfin-Membership-Container'>
					${this.getFilteredItems(data).map((membership, i) => {
						return html`
							<div class='Endorfin-Membership'>
								<div class='Endorfin-Membership-Title'>${membership.title}</div>
								<${AccordionBody} data=${membership} />
							</div>
							`
			})}
									</div>
				`;
		}
	}

	function scrollTo() {
		location.href = `#scrollTo`;
	}

	function AccordionBody(props) {
		return (html`
				<div class='Endorfin-Membership-Body'>
					<div class="Endorfin-Membership-Excerpt">${props.data.excerpt}</div>
									<div class='Endorfin-Membership-Price'>${props.data.pricetext}</div>
									<div class='Endorfin-Membership-Buttons'><button onclick=${() => window.open(props.data.link, '_blank')} class='Endorfin-Membership-Button'>${props.data.link_text}</button></div>
							</div>`)
	}

		function getTerms() {
			const ordinarieTerm = getTermByName("ordinarie");
			const studerandeTerm = getTermByName("studerande");
			const seniorTerm = getTermByName("senior");
			const ungdomTerm = getTermByName("ungdom");
			const klippkortTerm = getTermByName("klippkort");
	
			const terms = [ordinarieTerm, studerandeTerm, seniorTerm, ungdomTerm, klippkortTerm];

			return terms;
		}

		function getTermByName(termName) {
			const terms = jsondata.terms;
			const index = terms.findIndex((term) => {
				return term.name.toUpperCase().includes(termName.toUpperCase());
			});

			return terms[index];
		}

		function getOrdinarieMemberships() {
			const gym = getMembershipByNames("ordinarie", "gym");
			const grupp = getMembershipByNames("ordinarie", "gruppträning");
			const endorfinKortet = getMembershipByNames("ordinarie", "endorfinkortet");
			const crossfit = getMembershipByNames("ordinarie", "crossfit");

			const memberShips = [gym, grupp, endorfinKortet, crossfit];

			return memberShips;
		}

		function getStuderandeMemberships() {
			const gym = getMembershipByNames("studerande", "gym");
			const endorfinKortet = getMembershipByNames("studerande", "endorfinkortet");
			const crossfit = getMembershipByNames("studerande", "crossfit");

			const memberships = [gym, endorfinKortet, crossfit];

			return memberships;
		}

		function getSeniorMemberships() {
			const gym = getMembershipByNames("senior", "gym");
			const endorfinKortet = getMembershipByNames("senior", "endorfinkortet");
			const crossfit = getMembershipByNames("senior", "crossfit");

			const memberships = [gym, endorfinKortet, crossfit];

			return memberships;
		}

		function getUngdomMemberships() {
			const sexmanader = getMembershipByNames("ungdom", "ungdomskort 6 mån");
			const tolvmanader = getMembershipByNames("ungdom", "ungdomskort 12 mån");

			const memberships = [sexmanader, tolvmanader];

			return memberships;
		}

		function getKlippKortMemberships() {
			const tioKort = getMembershipByNames("klippkort", "10-kort");
			const tioKortSeniorStuderande = getMembershipByNames("klippkort", "10-kort senior");
			const tioKortCrossfit = getMembershipByNames("klippkort", "10-kort crossfit");
			const tvaVeckorStart = getMembershipByNames("klippkort", "2 veckor start");
			const besoksVeckor = getMembershipByNames("klippkort", "besöksveckor");

			const memberships = [tioKort, tioKortSeniorStuderande, tioKortCrossfit, tvaVeckorStart, besoksVeckor];

			return memberships;
		}

		function getMembershipByNames(termName, membershipTitle) {
			var memberships = data;
			memberships = filterOutNoTermMemberships(memberships);

			var termMemberships = memberships.filter(membership => {
				const term = membership.terms[0];

				return term.name.toUpperCase().includes(termName.toUpperCase())
					&& membership.title.toUpperCase() == membershipTitle.toUpperCase();
			});

			if(termMemberships.length > 0)
				return termMemberships[0];

			termMemberships = memberships.filter(membership => {
				const term = membership.terms[0];

				return term.name.toUpperCase().includes(termName.toUpperCase())
					&& membership.title.toUpperCase().includes(membershipTitle.toUpperCase());
			});

			return termMemberships[0];
		}

		function filterOutNoTermMemberships(memberships) {
			const filteredMemberships = memberships.filter(membership => {
				if(!membership.terms)
					return false;

				if(membership.terms.length == 0)
					return false;

				return true;
			});

			return filteredMemberships;
		}

		render(html`<${App}/>`, document.getElementById('Endorfin-Memberships'));
}
