<?php

namespace EndorfinKnowe;

final class Employee_Filter_Shortcodes
{
	public static function employees($attr) : string
	{
		$args = [
			'post_type' => 'employee',
			'tax_query' => [
				[
					'taxonomy' => 'employee_facility',
					'field' => 'slug',
					'terms' => [$attr['facility']]
				],
				[
					'taxonomy' => 'employee_role',
					'field' => 'slug',
					'terms' => [$attr['role']]
				]
			]
		];

		$query = new \WP_Query($args);
		$rows = $query->posts;

		$emp = '';

		foreach ($rows as $row) {
			$emp .= self::get_employee_card($row, $attr);
		}

		$html = "
		<div class='Endorfin-EmpolyeContainer'>
			{$emp}
		</div>

		";

		return $html;
	}

	private static function get_employee_card($data, $attr) : string
	{
		$tag_text = self::get_tags_text($data);
		$role = get_term_by('slug', $attr['role'], 'employee_role');
		$image = get_the_post_thumbnail_url($data);

		return "
			<div class='Endorfin-EmpolyeeCard'>
				<div class='Endorfin-EmployeeImageContainer'>
					<img src='{$image}' />
				</div>
				<div class='Endorfin-EmpolyeeTitle'>{$data->post_title}</div>
				<div class='Endorfin-EmpolyeeRole'>{$role->name}</div>
				<hr class='Endorfin-EmpolyeeDivider'/>
				<div class='Endorfin-EmpolyeeTag'>{$tag_text}</div>
			</div>
		";
	}

	private static function get_tags_text($post) : string
	{
		$tags = get_the_terms($post, 'employee_tag');
		$ret = '';

		if (!$tags) {
			return $ret;
		}

		foreach ($tags as $tag) {
			$ret .= "{$tag->name}, ";
		}

		return substr($ret, 0, -2);
	}

}
