<?php

namespace EndorfinKnowe;

use \add_action, \register_post_types, \register_taxonomy, \add_shortcode, \add_meta_box;

final class Add_New_Supply_View
{
	function __construct()
	{
		$this->init();
	}

	private function init() : void
	{
		$this->add_script_file();
		$this->add_style();
		$this->add_actions();
	}

	private function add_script_file() : void
	{
		wp_enqueue_script("endorfin-add-new-supplies-view-script", plugin_dir_url(__FILE__) . 'scripts/index.js', array(), '1.0.0');

	}

	private function add_style() : void
	{
		wp_enqueue_style('endorfin-add-new-supplies-view-styles', plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');
	}

	private function add_actions() : void
	{
		add_action('admin_init', function () {
			$this->insert_input_fields();
		});

		add_action('save_post', function () {
			$this->save_input_data();
		});
	}

	private function insert_input_fields() : void
	{

		add_meta_box(
			"supplies_meta",
			"Attribut",
			function () { $this->build_input_fields(); },
			"supplies",
			"normal",
			"low");
	}

	private function build_input_fields() : void
	{
		$meta_attributes = $this->get_supply_attributes();

		$buttons = get_post_meta( get_the_ID(), "custom_buttons", true );
		if(!$buttons || !is_array($buttons)) {
			$buttons = array( array( 'label' => '', 'url' => '' ) );
		}
		?>

			<form method="post" enctype="multipart/form-data">
				<div class="add-new-supply-outer-column">

					<div class="add-new-supply-input-row">
						<label>Balans:</label>
						<input type="text" name="balance" value="<?php echo $meta_attributes["balance"];?>" class="width99" />
					</div>

					<div class="add-new-supply-input-row">
						<label>Kondition:</label>
						<input type="text" name="cardio" value="<?php echo $meta_attributes["condition"];?>" class="width99" />
					</div>

					<div class="add-new-supply-input-row">
						<label>Koreografi:</label>
						<input type="text" name="choreography" value="<?php echo $meta_attributes["choreography"];?>" class="width99" />
					</div>

					<div class="add-new-supply-input-row">
						<label>Styrka:</label>
						<input type="text" name="strength" value="<?php echo $meta_attributes["strength"];?>" class="width99" />
					</div>

					<div class="add-new-supply-input-row">
						<label>Tid:</label>
						<input type="text" name="time" value="<?php echo $meta_attributes["time"];?>" class="width99" />
					</div>

					<div class="custom-buttons-container ">
						<?php foreach ( $buttons as $i => $button ) : ?>
							<div class="custom-button-field">
								<div class="add-new-supply-input-row">
									<label for="custom_button_label_<?php echo $i; ?>">Text:</label>
									<input type="text" id="custom_button_label_<?php echo $i; ?>" name="custom_button_label[]" value="<?php echo esc_attr( $button['label'] ); ?>" class="width99" />

									<label class="add-new-supply-button-lable" for="custom_button_url_<?php echo $i; ?>">URL:</label>
									<input class="add-new-supply-button-url" type="text" id="custom_button_url_<?php echo $i; ?>" name="custom_button_url[]" value="<?php echo esc_attr( $button['url'] ); ?>" />
									<button class="button remove-button" <?php echo ($i == 0 ? 'style="display: none;"':''); ?>>Ta bort knapp</button>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
					<button class="button add-button">Lägg till knapp</button>
				</div>
			</form>

		<?php
	}

	private function get_supply_attributes() : array
	{
		$meta_attributes = array(
			"time" => "",
			"condition" => "",
			"strength" => "",
			"balance" => "",
			"choreography" => "",
			"custom_buttons" => array(),
		);

		if (isset($_GET['post'])) {
			$supply_id = $_GET['post'];
			$meta_attributes = array(
				"time" => get_post_meta($supply_id, 'Time', true),
				"condition" => get_post_meta($supply_id, 'Kondition', true),
				"strength" => get_post_meta($supply_id, 'Styrka', true),
				"balance" => get_post_meta($supply_id, 'Balans', true),
				"choreography" => get_post_meta($supply_id, 'Koreografi', true)
			);
			$custom_buttons = get_post_meta( $supply_id, 'custom_buttons', true );
			if ( $custom_buttons ) {
				$meta_attributes['custom_buttons'] = $custom_buttons;
			}
		}
		return $meta_attributes;

	}

	function save_input_data() : void
	{
		global $post;
		if ($post != null) {
			if (isset($_POST["balance"])) {
				update_post_meta($post->ID, "Balans", sanitize_text_field($_POST["balance"]));
			}
			if (isset($_POST["cardio"])) {
				update_post_meta($post->ID, "Kondition", sanitize_text_field($_POST["cardio"]));
			}
			if (isset($_POST["choreography"])) {
				update_post_meta($post->ID, "Koreografi", sanitize_text_field($_POST["choreography"]));
			}
			if (isset($_POST["strength"])) {
				update_post_meta($post->ID, "Styrka", sanitize_text_field($_POST["strength"]));
			}
			if (isset($_POST["time"])) {
				update_post_meta($post->ID, "Time", sanitize_text_field($_POST["time"]));
			}
			if(isset($_POST["custom_button_label"]) && isset($_POST["custom_button_url"])) {
				$custom_buttons = array_map(function($label, $url) {
					return array('label' => sanitize_text_field($label), 'url' => esc_url_raw($url));
				}, $_POST['custom_button_label'], $_POST['custom_button_url']);
				update_post_meta($post->ID, "custom_buttons", $custom_buttons);
			}
		}
	}
}
