<?php

namespace EndorfinKnowe;

use \add_action, \register_post_types, \register_taxonomy, \add_shortcode;

final class Employee_Filter
{
	function __construct()
	{
		require  ENDORFIN_KNOWE_ROOT_DIR . '/employee-filter/employee-filter-shortcodes.php';

		add_action('init', function () {
			$this->register_post_types();
			$this->register_taxonomies();
			$this->register_shortcodes();
		});


		add_action('wp_enqueue_scripts', function () {
			wp_enqueue_script('endorfin-employee-filter-scripts', plugin_dir_url(__FILE__) . 'scripts/index.js', array(), '1.0.0', true);
			wp_enqueue_style('endorfin-employee-filter-styles', plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');
		});
	}

	private function register_post_types() : void
	{
		register_post_type('employee', [
			'label' => __('Personal', 'Endorfin'),
			'public' => true,
			'menu_position' => 5,
			'menu_icon' => 'dashicons-admin-users',
			'supports' => ['title', 'thumbnail', 'author'],
			'show_in_rest' => true,
			'rewrite' => ['slug' => 'employee'],
			'taxonomies' => ['book_author'],
			'labels' => [
				'singular_name' => __('Anställd', 'Endorfin'),
				'add_new_item' => __('Lägg till anställd',
					'Endorfin'
				),
				'new_item' => __('Ny personal', 'Endorfin'),
				'view_item' => __('Visa personal', 'Endorfin'),
				'not_found' => __('Ingen personal hittades', 'Endorfin'),
				'not_found_in_trash' => __('Ingen personal hittades soptunnan', 'Endorfin'),
				'all_items' => __('Alla personal', 'Endorfin'),
				'insert_into_item' => __('Lägg till i personal', 'Endorfin')
			],
		]);

	}

	private function register_taxonomies() : void
	{
		register_taxonomy('employee_facility', ['employee'], [
			'label' => __('Anläggning', 'Endorfin'),
			'hierarchical' => true,
			'rewrite' => ['slug' => 'employee-facility'],
			'show_admin_column' => true,
			'show_in_rest' => true,
			'labels' => [
				'singular_name' => __('Anläggning', 'Endorfin'),
				'all_items' => __('Alla Anläggning', 'Endorfin'),
				'edit_item' => __('Ändra Anläggning', 'Endorfin'),
				'view_item' => __('Visa Anläggning', 'Endorfin'),
				'update_item' => __('Uppdatera Anläggning', 'Endorfin'),
				'add_new_item' => __('Lägg till Anläggning', 'Endorfin'),
				'new_item_name' => __('Ny Anläggning', 'Endorfin'),
				'search_items' => __('Sök Anläggning',
					'Endorfin'
				),
				'not_found' => __('ingen Anläggning hittades',
					'Endorfin'
				),
			]
		]);

		register_taxonomy('employee_role', ['employee'], [
			'label' => __('Roll', 'Endorfin'),
			'hierarchical' => true,
			'rewrite' => ['slug' => 'employee-role'],
			'show_admin_column' => true,
			'show_in_rest' => true,
			'labels' => [
				'singular_name' => __('Roll', 'Endorfin'),
				'all_items' => __('Alla Roll', 'Endorfin'),
				'edit_item' => __('Ändra Roll', 'Endorfin'),
				'view_item' => __('Visa Roll', 'Endorfin'),
				'update_item' => __('Uppdatera Roll', 'Endorfin'),
				'add_new_item' => __('Lägg till Roll', 'Endorfin'),
				'new_item_name' => __('Ny Roll', 'Endorfin'),
				'search_items' => __('Sök Roll',
					'Endorfin'
				),
				'not_found' => __('Ingen Roll hittades',
					'Endorfin'
				),
			]
		]);

		register_taxonomy('employee_tag', ['employee'], [
			'label' => __('Träningsform', 'Endorfin'),
			'hierarchical' => true,
			'rewrite' => ['slug' => 'employee-tag'],
			'show_admin_column' => true,
			'show_in_rest' => true,
			'labels' => [
				'singular_name' => __('Träningsform', 'Endorfin'),
				'all_items' => __('Alla Träningsform', 'Endorfin'),
				'edit_item' => __('Ändra Träningsform', 'Endorfin'),
				'view_item' => __('Visa Träningsform', 'Endorfin'),
				'update_item' => __('Uppdatera Träningsform', 'Endorfin'),
				'add_new_item' => __('Lägg till Träningsform', 'Endorfin'),
				'new_item_name' => __('Ny Träningsform', 'Endorfin'),
				'search_items' => __('Sök Träningsform',
					'Endorfin'
				),
				'not_found' => __('Ingen Träningsform hittades',
					'Endorfin'
				),
			]
			]);

		register_taxonomy_for_object_type('employee_facility', 'employee');
		register_taxonomy_for_object_type('employee_role', 'employee');
		register_taxonomy_for_object_type('employee_tag', 'employee');

	}

	private function register_shortcodes() : void
	{
		add_shortcode('endorfin-employees', fn($attr) => Employee_Filter_Shortcodes::employees($attr));
	}
}
