<?php

namespace EndorfinKnowe;

use \add_action, \register_post_types, \register_taxonomy, \add_shortcode;

final class Supply_Filter
{
	function __construct()
	{
		require  ENDORFIN_KNOWE_ROOT_DIR . '/supply-filter/supply-filter-shortcodes.php';

		add_action('init', function () {
			$this->register_post_types();
			$this->register_taxonomies();
			$this->register_shortcodes();
		});

		add_action('wp_enqueue_scripts', function () {
			wp_enqueue_script('endorfin-supplies-filter-scripts', plugin_dir_url(__FILE__) . 'scripts/index.js', array(), '1.0.0', true);
			wp_enqueue_style('endorfin-supplies-filter-styles', plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');
		});

		add_filter('script_loader_tag', function ($tag, $handle, $src) {
			// if not your script, do nothing and return original $tag
			if ('endorfin-supplies-filter-scripts' !== $handle) {
				return $tag;
			}

			// change the script tag by adding type="module" and return it.
			$tag = '<script type="module" src="' . esc_url( $src ) . '"></script>';

			return $tag;
		} , 10, 3);
	}

	private function register_post_types() : void
	{
		register_post_type('supplies', [
			'label' => __('Utbud', 'Endorfin'),
			'public' => true,
			'menu_position' => 5,
			'menu_icon' => 'dashicons-portfolio',
			'supports' => ['title', 'thumbnail', 'author', 'excerpt', 'custom-fields'],
			'show_in_rest' => true,
			'rewrite' => ['slug' => 'supplies'],
			'taxonomies' => ['book_author', 'book_genre'],
			'labels' => [
				'singular_name' => __('Utbud', 'Endorfin'),
				'add_new_item' => __('Lägg till utbud',
					'Endorfin'
				),
				'new_item' => __('Ny utbud', 'Endorfin'),
				'view_item' => __('Visa utbudet', 'Endorfin'),
				'not_found' => __('Inget utbud hittades', 'Endorfin'),
				'not_found_in_trash' => __('Inget utbud hittades soptunnan', 'Endorfin'),
				'all_items' => __('Allt utbud', 'Endorfin'),
				'insert_into_item' => __('Lägg till i utbud', 'Endorfin')
			],
		]);

	}

	private function register_taxonomies() : void
	{
		register_taxonomy('supplies_type', ['supplies'], [
			'label' => __('Utbud', 'Endorfin'),
			'hierarchical' => true,
			'rewrite' => ['slug' => 'supplies-type'],
			'show_admin_column' => true,
			'show_in_rest' => true,
			'labels' => [
				'singular_name' => __('Typ', 'Endorfin'),
				'all_items' => __('Alla Typer', 'Endorfin'),
				'edit_item' => __('Ändra Typ', 'Endorfin'),
				'view_item' => __('Visa Typer', 'Endorfin'),
				'update_item' => __('Uppdatera Typ', 'Endorfin'),
				'add_new_item' => __('Lägg till Typ', 'Endorfin'),
				'new_item_name' => __('Ny Typ', 'Endorfin'),
				'search_items' => __('Sök Typer',
					'Endorfin'
				),
				'not_found' => __('Inga Typer hittades',
					'Endorfin'
				),
			]
		]);

		register_taxonomy_for_object_type('supply_type', 'supplies');

	}

	private function register_shortcodes() : void
	{
		add_shortcode('endorfin-supplies', fn($attr) => Supplies_Filter_Shortcodes::supplies($attr));
	}
}
