<?php

namespace EndorfinKnowe;

final class Supplies_Filter_Shortcodes
{
	public static function supplies($attr) : string
	{
		$args = [
			'post_type' => 'supplies',
			'posts_per_page' => 9999
		];

		$query = new \WP_Query($args);
		$rows = $query->posts;


		$data = array_map(fn($row) => [
			'id' => $row->ID,
			'terms' => get_the_terms($row->ID, 'supplies_type'),
			'time' => get_post_meta($row->ID, 'Time', true),
			'condition' => get_post_meta($row->ID, 'Kondition', true),
			'strength' => get_post_meta($row->ID, 'Styrka', true),
			'balance' => get_post_meta($row->ID, 'Balans', true),
			'choreography' => get_post_meta($row->ID, 'Koreografi', true),
			'title' => $row->post_title,
			'excerpt' => $row->post_excerpt,
			'image' => get_the_post_thumbnail_url($row)
		], $rows)
		;


		$json = json_encode($data);


		$html = "
			<div id='Endorfin-Supplies' class='Endorfin-Supplies'>
			</div>
			<script>
				window._ENDORFIN_SUPPLIES = {$json};
			</script>
		";

		return $html;
	}


}
