<?php

namespace EndorfinKnowe;

use \add_action, \register_post_types, \register_taxonomy, \add_shortcode, \add_meta_box;

final class Edit_Membership_View 
{
    function __construct()
    {
        $this->init();
    }

    private function init() : void 
    {
		$this->add_script();
		$this->add_style();
		$this->add_actions();
    }

	private function add_script() : void
	{
		wp_enqueue_script( "endorfin-add-new-supplies-view-script", plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');
	}

    private function add_style() : void
	{
		wp_enqueue_style('endorfin-add-new-memberships-view-styles', plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');
	}

	private function add_actions() : void
	{
		add_action('admin_init', function () {
			$this->insert_input_fields();
		});

		add_action('save_post', function () {
			$this->save_input_data();
		});
	}

	private function insert_input_fields() : void
	{
		add_meta_box(
			"membership_meta",
			"Attribut",
			function () { $this->build_input_fields(); }, 
			"membership", 
			"normal", 
			"low");
	}

	private function build_input_fields() : void
	{
		$price = $this->get_membership_price();

		?>

			<form method="post" enctype="multipart/form-data">
				<div class="add-new-membership-outer-column">
					
					<div class="add-new-membership-input-row">
						<label>Pristext:</label>
						<input type="text" name="price" value="<?php echo $price;?>" class="width99" />
					</div>
					
				</div>
			</form>
				
		<?php
	}

	private function get_membership_price() : string {
		$price = "";

		$membership_id = $_GET['post'];
		if ($membership_id != null) 
			$price = get_post_meta($membership_id, 'pristext', true);

		return $price;
	}

	function save_input_data() : void
	{
        global $post;

		if ($post == null)
			return;

		$input_price = $_POST["price"];

		$this->update_membership_price($post->ID, $input_price);
	}

	private function update_membership_price($membership_id, $price) : void
	{
		update_post_meta($membership_id, "pristext", $price);
	}
}