<?php

namespace EndorfinKnowe;

use \add_action, \register_post_types, \register_taxonomy, \add_shortcode, \add_meta_box;

final class Add_New_Supply_View
{
	function __construct()
	{
		$this->init();
	}

	private function init() : void 
	{
		$this->add_script_file();
		$this->add_style();
		$this->add_actions();
	}

	private function add_script_file() : void
	{
		wp_enqueue_script("endorfin-add-new-supplies-view-script", plugin_dir_url(__FILE__) . 'scripts/index.js', array(), '1.0.0');
	}

	private function add_style() : void
	{
		wp_enqueue_style('endorfin-add-new-supplies-view-styles', plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');
	}

	private function add_actions() : void
	{
		add_action('admin_init', function () {
			$this->insert_input_fields();
		});

		add_action('save_post', function () {
			$this->save_input_data();
		});
	}

	private function insert_input_fields() : void
	{
		add_meta_box(
			"supplies_meta",
			"Attribut",
			function () { $this->build_input_fields(); }, 
			"supplies", 
			"normal", 
			"low");
	}

	private function build_input_fields() : void
	{
		$meta_attributes = $this->get_supply_attributes();
		
		?>

			<form method="post" enctype="multipart/form-data">
				<div class="add-new-supply-outer-column">
					
					<div class="add-new-supply-input-row">
						<label>Balans:</label>
						<input type="text" name="balance" value="<?php echo $meta_attributes["balance"];?>" class="width99" />
					</div>
					
					<div class="add-new-supply-input-row">
						<label>Kondition:</label>
						<input type="text" name="cardio" value="<?php echo $meta_attributes["condition"];?>" class="width99" />
					</div>
					
					<div class="add-new-supply-input-row">
						<label>Koreografi:</label>
						<input type="text" name="choreography" value="<?php echo $meta_attributes["choreography"];?>" class="width99" />
					</div>
					
					<div class="add-new-supply-input-row">
						<label>Styrka:</label>
						<input type="text" name="strength" value="<?php echo $meta_attributes["strength"];?>" class="width99" />
					</div>
					
					<div class="add-new-supply-input-row">
						<label>Tid:</label>
						<input type="text" name="time" value="<?php echo $meta_attributes["time"];?>" class="width99" />
					</div>
					
				</div>
			</form>
				
		<?php
	}

	private function get_supply_attributes() : array
	{
		$meta_attributes = array(
			"time" => "",
			"condition" => "",
			"strength" => "",
			"balance" => "",
			"choreography" => ""
		);

		$supply_id = $_GET['post'];
		if ($supply_id != null)
			$meta_attributes = array(
				"time" => get_post_meta($supply_id, 'Time', true),
				"condition" => get_post_meta($supply_id, 'Kondition', true),
				"strength" => get_post_meta($supply_id, 'Styrka', true),
				"balance" => get_post_meta($supply_id, 'Balans', true),
				"choreography" => get_post_meta($supply_id, 'Koreografi', true)
			);

		return $meta_attributes;
	}

	function save_input_data() : void
	{
		global $post;

		if ($post == null)
			return;

		update_post_meta($post->ID, "Balans", $_POST["balance"]);
		update_post_meta($post->ID, "Kondition", $_POST["cardio"]);
		update_post_meta($post->ID, "Koreografi", $_POST["choreography"]);
		update_post_meta($post->ID, "Styrka", $_POST["strength"]);
		update_post_meta($post->ID, "Time", $_POST["time"]);
	}
}
