<?php

namespace EndorfinKnowe;

final class Membership_Filter_Shortcodes
{
	public static function memberships($attr) : string
	{
		$args = [
			'post_type' => 'membership',
			'posts_per_page' => 9999
		];
		
		$query = new \WP_Query($args);
		$rows = $query->posts;

		$link = 'https://endorfin.brponline.se/#/wizard/subscription/sign/selectbusinessunit?abortState=app.webcategories';
		$link_text = __('VÄLJ', 'Endorfin');

		$terms = get_terms([
			'taxonomy' => 'membership_category',
			'hide_empty' => false,
		]);

		$data = array_map(fn($row) => [
			'id' => $row->ID,
			'terms' => get_the_terms($row->ID, 'membership_category'),
			'pricetext' => $row->pristext,
			'title' => $row->post_title,
			'excerpt' => $row->post_excerpt,
			'link' => $link,
			'link_text' => $link_text
		], $rows);

		$json_data = (object) [
			'terms' => $terms,
			'data' => $data
		];

		$json = json_encode($json_data);

		$html = "<div id='Endorfin-Memberships' class='Endorfin-Memberships'>
		</div>
		<script>
			window._ENDORFIN_MEMBERSHIPS = {$json};
		</script>";

		return $html;
	}

	private static function get_membership_card($data, $attr) : string
	{
		return "
			<div class='Endorfin-MembershipCard'>
				<div class='Endorfin-MembershipInfo'>
					<div class='Endorfin-MembershipTitle'>{$data->post_title}</div>
					<div class='Endorfin-MembershipDescription'>{$data->post_excerpt}</div>
					<div class='Endorfin-MembershipPriceText'>{$data->pristext}</div>
					<div class='Endorfin-MembershipLink'><a href='{$link}' target='_blank'>{$link_text}</a></div>
				</div>
			</div>
		";
	}
}
