<?php

namespace EndorfinKnowe;

use \add_action, \register_post_types, \register_taxonomy, \add_shortcode, \add_meta_box;

final class Add_New_Supply_View
{
	function __construct()
	{
		$this->init();
	}

	private function init() : void 
	{
		$this->add_style();
		$this->add_actions();
	}

	private function add_style() : void {
		wp_enqueue_style('endorfin-add-new-supplies-view-styles', plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');
	}

	private function add_actions() : void
	{
		add_action('init', function () {
			$this->register_taxonomies();
		});

		add_action('admin_init', function () {
			$this->insert_input_fields();
		});

		add_action('save_post', function () {
			$this->save_input_data();
		});
	}

	private function insert_input_fields() : void
	{
		add_meta_box(
			"supplies_meta",
			"Egenskaper",
			function () { $this->build_input_fields(); }, 
			"supplies", 
			"normal", 
			"low");
	}

	private function build_input_fields() : void
	{
		$post_id = $_GET['post'];

		$time = get_post_meta($post_id, 'Time', true);
		$condition = get_post_meta($post_id, 'Kondition', true);
		$strength = get_post_meta($post_id, 'Styrka', true);
		$balance = get_post_meta($post_id, 'Balans', true);
		$choreography = get_post_meta($post_id, 'Koreografi', true);
		
		?>

			<form method="post" enctype="multipart/form-data">
				<div class="add-new-supply-outer-column">
					
					<div class="add-new-supply-input-row">
						<label>Balans:</label>
						<input type="text" name="balance" value="<?php echo $balance;?>" class="width99" />
					</div>
					
					<div class="add-new-supply-input-row">
						<label>Kondition:</label>
						<input type="text" name="cardio" value="<?php echo $condition;?>" class="width99" />
					</div>
					
					<div class="add-new-supply-input-row">
						<label>Koreografi:</label>
						<input type="text" name="choreography" value="<?php echo $choreography;?>" class="width99" />
					</div>
					
					<div class="add-new-supply-input-row">
						<label>Styrka:</label>
						<input type="text" name="strength" value="<?php echo $strength;?>" class="width99" />
					</div>
					
					<div class="add-new-supply-input-row">
						<label>Tid:</label>
						<input type="text" name="time" value="<?php echo $time;?>" class="width99" />
					</div>
					
				</div>
			</form>
				
		<?php
	}

	private function register_taxonomies() : void
	{
		register_taxonomy('supplies_type', ['supplies'], [
			'label' => __('Utbud', 'Endorfin'),
			'hierarchical' => true,
			'rewrite' => ['slug' => 'supplies-type'],
			'show_admin_column' => true,
			'show_in_rest' => true,
			'labels' => [
				'singular_name' => __('Typ', 'Endorfin'),
				'all_items' => __('Alla Typer', 'Endorfin'),
				'edit_item' => __('Ändra Typ', 'Endorfin'),
				'view_item' => __('Visa Typer', 'Endorfin'),
				'update_item' => __('Uppdatera Typ', 'Endorfin'),
				'add_new_item' => __('Lägg till Typ', 'Endorfin'),
				'new_item_name' => __('Ny Typ', 'Endorfin'),
				'search_items' => __('Sök Typer',
					'Endorfin'
				),
				'not_found' => __('Inga Typer hittades',
					'Endorfin'
				),
			]
		]);

		register_taxonomy_for_object_type('supply_type', 'supplies');
	}
	
	function save_input_data()
	{
		global $post;

		update_post_meta($post->ID, "Balans", $_POST["balance"]);
		update_post_meta($post->ID, "Kondition", $_POST["cardio"]);
		update_post_meta($post->ID, "Koreografi", $_POST["choreography"]);
		update_post_meta($post->ID, "Styrka", $_POST["strength"]);
		update_post_meta($post->ID, "Time", $_POST["time"]);
	}
}
