
import { h, Component, render } from 'https://unpkg.com/preact?module';
import htm from 'https://unpkg.com/htm?module';

// Initialize htm with Preact
const html = htm.bind(h);
const data = window._ENDORFIN_SUPPLIES;

const terms = data.reduce((acc, curr) => {
	curr.terms.forEach(term => {
		if (!acc.some(item => item.term_id === term.term_id)) {
			acc.push(term);
		}

	});

	return acc;
}, []);


function App () {
	return html`
		<div>
			<${Accordion}/>
		</div>
	`;
}

class Accordion extends Component {
	state = {
		isActiveIndex: null,
		activeTerm: terms[0]
	}

	handleClick = (index) => {
		this.setState(() => ({
			isActiveIndex: index
		 }))
	}

	onFilterClick = (term) => {
		this.setState(() => ({ activeTerm: term}))
	}

	filterItems = data => {
		return this.state.activeTerm ? data.filter(item => {
			return item.terms.some(term => term.term_id === this.state.activeTerm.term_id);
		}) : data;
	}

	render() {
			return html`
				<div>
					<div class="Endorfin-CategoryFilter">
					${terms.map((term, i) => {
						return html`
							<div class="Endorfin-CategoryFilter-item ${term.term_id === this.state.activeTerm.term_id ? 'Endorfin-CategoryFilter-item--active' : ''}" onClick=${() => this.onFilterClick(term)}>
								<img class='Endorfin-CategoryFilter-image' src="/wp-content/uploads/supply_${term.slug}.jpg"/>
								<div class="Endorfin-CategoryFilter-itemLabel">${term.name}</div>
							</div>
							`
					})}
					</div>
					<h2 class="Endorfin-CategoryFilter-Header">${this.state.activeTerm.name}</h2>

				</div>
				${this.filterItems(data).map((supply, i) => {
					return html`
						<div onClick=${() => this.handleClick(this.state.isActiveIndex === i ?  null : i) } class=${this.state.isActiveIndex === i ? 'Endorfin-Accordion-Header-Open' : 'Endorfin-Accordion-Header-Closed'}>
							<div class='Endorfin-Accordion-HeaderTitle'>${supply.title}
								${this.state.isActiveIndex === i ?
									html`<span class='et-pb-icon' style='font-size: 23px; color: #512D79; '>2</span>`
									: html`<span class='et-pb-icon' style='font-size: 23px; color: white;'>3</span>`}
							</div>
							${this.state.isActiveIndex === i ? html`<${AccordionBody } data=${supply} />` : ''}
						</div>
						`
				})}
			`;
		}
	}

  function AccordionBody(props) {
		return (html`
			<div class='Endorfin-Accordion-Body'>
				<div class='Endorfin-AccordionImageContainer'>
					<img src=${props.data.image} />
				</div>
				<div>
				${props.data.time ? html`
					<div class='Endorfin-AccordionTime'>
						<span style='font-size: 23px; padding-right: 12px; color: #8BC11F;' class='et-pb-icon'>;</span>
						<div>${props.data.time} MIN </div>
					</div>` : ''}
					<div class='Endorfin-AccordionImageExcerpt'>${props.data.excerpt}</div>
				</div>
			</div>

			<div class='Endorfin-ProgressContainer'>
				<div class="Endorfin-Progress">
					<div class="Endorfin-ProgressLabel">Kondition</div>
					<${ProgressBar} progress=${props.data.condition}/>
				</div>

				<div class="Endorfin-Progress">
					<div class="Endorfin-ProgressLabel">Styrka</div>
					<${ProgressBar} progress=${props.data.strength}/>
				</div>

				<div class="Endorfin-Progress">
					<div class="Endorfin-ProgressLabel">Balans</div>
					<${ProgressBar} progress=${props.data.balance}/>
				</div>

				<div class="Endorfin-Progress">
					<div class="Endorfin-ProgressLabel">Koreografi</div>
					<${ProgressBar} progress=${props.data.choreography}/>
				</div>
			</div>
			<div class='Endorfin-AccordionButtons'>
				<button onclick=${() => window.open('https://endorfin.brponline.se/#/wizard/subscription/sign/selectsubscription?webCategory=11&abortState=app.webcategories')} class='Endorfin-AccordionSignUp'>BLI MEDLEM</button>
				<button  onclick=${() => window.open('https://endorfin.brponline.se/#/groupactivities')} class='Endorfin-AccordionBooking'>BOKA PASS</button>
			</div>
		`)
	}

	function ProgressBar(props) {
		const p = Number(props.progress);

		return html`<div class="Endorfin-ProgressBar">
			<div class="Endorfin-ProgressBar-item ${p >= 1 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
			<div class="Endorfin-ProgressBar-item ${p >= 2 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
			<div class="Endorfin-ProgressBar-item ${p >= 3 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
			<div class="Endorfin-ProgressBar-item ${p >= 4 ? 'Endorfin-ProgressBar-item--active' : ''}"/>
		</div>`;
	}


render(html`<${App}/>`, document.getElementById('Endorfin-Supplies'));

/*



*/
