
import { h, Component, render } from 'https://unpkg.com/preact?module';
import htm from 'https://unpkg.com/htm?module';

// Initialize htm with Preact
const html = htm.bind(h);
const jsondata = window._ENDORFIN_MEMBERSHIPS;
const data = jsondata.data;
const terms = jsondata.terms;


function App () {
	return html`
		<div >
			<${Accordion}/>
		</div>
	`;
}

class Accordion extends Component {
	state = {
		isActiveIndex: null,
		activeTerm: terms[0]
	}

	handleClick = (index) => {
		this.setState(() => ({
			isActiveIndex: index
		 }))
	}

	onFilterClick = (term) => {
		this.setState(() => ({ activeTerm: term}))
	}

	scrollTo()  {
		if(window.innerWidth < 500) {
			location.href = "#scrollTo"
		}
	}

	filterItems = data => {
		//const sortedItems = data.sort((a,b) => (a.terms.title > b.title) ? 1 : ((b.title > a.title) ? -1 : 0));

		return this.state.activeTerm ? data.filter(item => {
			return item.terms.some(term => term.term_id === this.state.activeTerm.term_id);
		}) : data;

	}

	render() {
			return html`
				<div>
					<div onClick=${this.scrollTo()}  class="Endorfin-MembershipFilter">
					${terms.map((term, i) => {
						return html`
							<div class="Endorfin-MembershipCategoryFilter-item ${term.term_id === this.state.activeTerm.term_id ? 'Endorfin-MembershipCategoryFilter-item--active' : ''}" onClick=${() => this.onFilterClick(term)}>
								<div class="Endorfin-MembershipCategoryFilter-itemLabel">${term.name}</div>
							</div>
							`
					})}
					</div>
					<h2 class="Endorfin-MembershipFilter-Header">${this.state.activeTerm.name}</h2>

				</div>
                <div class='Endorfin-Membership-Container'>
				${this.filterItems(data).map((membership, i) => {
					return html`
						<div class='Endorfin-Membership'>
							<div id='scrollTo' class='Endorfin-Membership-Title'>${membership.title}</div>
							<${AccordionBody } data=${membership} />
						</div>
						`
				})}
                </div>
			`;
		}
	}

	function AccordionBody(props) {
		return (html`
			<div class='Endorfin-Membership-Body'>
				<div class="Endorfin-Membership-Excerpt">${props.data.excerpt}</div>
                <div class='Endorfin-Membership-Price'>${props.data.pricetext}</div>
                <div class='Endorfin-Membership-Buttons'><button onclick=${() => window.open(props.data.link, '_blank')} class='Endorfin-Membership-Button'>${props.data.link_text}</button></div>
            </div>`)
	}

render(html`<${App}/>`, document.getElementById('Endorfin-Memberships'));


