<?php

namespace EndorfinKnowe;

use \add_action, \register_post_types, \register_taxonomy, \add_shortcode;

final class Membership_Filter
{
	function __construct()
	{
		require  ENDORFIN_KNOWE_ROOT_DIR . '/membership-filter/membership-filter-shortcodes.php';

		add_action('init', function () {
			$this->register_post_types();
			$this->register_taxonomies();
			$this->register_shortcodes();
		});


		add_action('wp_enqueue_scripts', function () {
			wp_enqueue_script('endorfin-membership-filter-scripts', plugin_dir_url(__FILE__) . 'scripts/index.js', array(), '1.0.0', true);
			wp_enqueue_style('endorfin-membership-filter-styles', plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');
		});

		add_filter('script_loader_tag', fn($tag, $handle, $src) => Membership_Filter::add_type_attribute($tag, $handle, $src) , 10, 3);
	}

	private function register_post_types() : void
	{
		register_post_type('membership', [
			'label' => __('Medlemskap', 'Endorfin'),
			'public' => true,
			'menu_position' => 6,
			'menu_icon' => 'dashicons-admin-users',
			'supports' => ['title', 'excerpt', 'custom-fields'],
			'show_in_rest' => true,
			'rewrite' => ['slug' => 'membership'],
			'taxonomies' => ['book_author'],
			'labels' => [
				'singular_name' => __('Medlemskap', 'Endorfin'),
				'add_new_item' => __('Lägg till medlemskap', 'Endorfin'),
				'new_item' => __('Nytt medlemskap', 'Endorfin'),
				'view_item' => __('Visa medlemskap', 'Endorfin'),
				'not_found' => __('Inget medlemskap hittades', 'Endorfin'),
				'not_found_in_trash' => __('Inget medlemskap hittades soptunnan', 'Endorfin'),
				'all_items' => __('Alla medlemskap', 'Endorfin'),
				'insert_into_item' => __('Lägg till i medlemskap', 'Endorfin')
			],
		]);

	}

	private function register_taxonomies() : void
	{
		register_taxonomy('membership_category', ['membership'], [
			'label' => __('Kategori', 'Endorfin'),
			'hierarchical' => true,
			'rewrite' => ['slug' => 'membership-category'],
			'show_admin_column' => true,
			'show_in_rest' => true,
			'labels' => [
				'singular_name' => __('Kategori', 'Endorfin'),
				'all_items' => __('Alla kategorier', 'Endorfin'),
				'edit_item' => __('Ändra kategori', 'Endorfin'),
				'view_item' => __('Visa kategorier', 'Endorfin'),
				'update_item' => __('Uppdatera kategori', 'Endorfin'),
				'add_new_item' => __('Lägg till kategori', 'Endorfin'),
				'new_item_name' => __('Ny kategori', 'Endorfin'),
				'search_items' => __('Sök kategorier', 'Endorfin' ),
				'not_found' => __('ingen kategori hittades', 'Endorfin'),
			]
		]);

		register_taxonomy_for_object_type('membership_category', 'membership');
	}

	private function register_shortcodes() : void
	{
		add_shortcode('endorfin-membership', fn($attr) => Membership_Filter_Shortcodes::memberships($attr));
	}



	public static function add_type_attribute($tag, $handle, $src) {
		if ( 'endorfin-membership-filter-scripts' !== $handle ) {
			return $tag;
		}
		
		$tag = '<script type="module" src="' . esc_url( $src ) . '"></script>';
		return $tag;
	}
}
