<?php

namespace EndorfinKnowe;

final class Membership_Filter_Shortcodes
{
	public static function memberships($attr) : string
	{
		// om attr är en tom sträng så kraschar allt
		// om facility eller role är en tom sträng så får man undefined array key-fel
		$category = $attr['category'];

		$args = [
			'post_type' => 'membership',
			'posts_per_page' => 9999,
			'tax_query' => [
				'taxonomy' => 'membership_category',
				'field' => 'slug',
				'terms' => [$category]
			]
		];
		
		$query = new \WP_Query($args);
		$rows = $query->posts;

		$link = 'https://endorfin.brponline.se/#/wizard/subscription/sign/selectbusinessunit?abortState=app.webcategories';
		$link_text = __('VÄLJ', 'Endorfin');

		$terms = get_terms([
			'taxonomy' => 'membership_category',
			'hide_empty' => false,
		]);

		$data = array_map(fn($row) => [
			'id' => $row->ID,
			'terms' => get_the_terms($row->ID, 'membership_category'),
			'pricetext' => $row->pristext,
			'title' => $row->post_title,
			'excerpt' => $row->post_excerpt,
			'link' => $link,
			'link_text' => $link_text
		], $rows);

		$json_data = (object) [
			'terms' => $terms,
			'data' => $data
		];

		$json = json_encode($json_data);

		// $m = '';

		// foreach ($rows as $row) {
		// 	$m .= self::get_membership_card($row, $attr);
		// }

		// $category_title = get_term_by('slug', $attr['category'], 'membership_category');


		$html = "<div id='Endorfin-Memberships' class='Endorfin-Memberships'>
		</div>
		<script>
			window._ENDORFIN_MEMBERSHIPS = {$json};
		</script>";

		// $html = "
		// <div class='Endorfin-MembershipContainer'>
		// <div class='Endorfin-MembershipCategory'>{$category_title->name}</div>
		// 	{$m}
		// </div>

		// ";

		return $html;
	}

	private static function get_membership_card($data, $attr) : string
	{
		$tag_text = self::get_tags_text($data);



		return "
			<div class='Endorfin-MembershipCard'>
				<div class='Endorfin-MembershipInfo'>
					<div class='Endorfin-MembershipTitle'>{$data->post_title}</div>
					<div class='Endorfin-MembershipDescription'>{$data->post_excerpt}</div>
					<div class='Endorfin-MembershipPriceText'>{$data->pristext}</div>
					<div class='Endorfin-MembershipLink'><a href='{$link}' target='_blank'>{$link_text}</a></div>
				</div>
			</div>
		";
	}

	private static function get_tags_text($post) : string
	{
		$tags = get_the_terms($post, 'employee_tag');
		$ret = '';

		if (!$tags) {
			return $ret;
		}

		foreach ($tags as $tag) {
			$ret .= "{$tag->name}, ";
		}

		return substr($ret, 0, -2);
	}

}
