<?php

namespace EndorfinKnowe;

use \add_action, \register_post_types, \register_taxonomy, \add_shortcode, \add_meta_box;

final class Add_New_Supply_View
{
	function __construct()
	{
		$this->init();
	}

	private function init() : void 
	{
		$this->add_actions();
	}

	private function add_actions() : void
	{
		wp_enqueue_style('endorfin-add-new-supplies-view-styles', plugin_dir_url(__FILE__) . 'styles/index.css', array(), '1.0.0');

		add_action('admin_init', function () {
			$this->insert_input_fields();
		});

		add_action('save_post', function () {
			$this->save_input_data();
		});
	}

	private function insert_input_fields() : void
	{
		add_meta_box(
			"supplies_meta",
			"Attribut",
			function () { $this->build_input_fields(); }, 
			"supplies", 
			"normal", 
			"low");
	}

	private function build_input_fields() : void
	{
		global $post;
		$custom = get_post_custom( $post->ID );
	
		?>

			<div class="add-new-supply-outer-column">

				<div class="add-new-supply-input-row">
					<label>Balans:</label>
					<input type="text" name="balance" value="" class="width99" />
				</div>

				<div class="add-new-supply-input-row">
					<label>Kondition:</label>
					<input type="text" name="cardio" value="" class="width99" />
				</div>

				<div class="add-new-supply-input-row">
					<label>Koreografi:</label>
					<input type="text" name="choreography" value="" class="width99" />
				</div>

				<div class="add-new-supply-input-row">
					<label>Styrka:</label>
					<input type="text" name="strength" value="" class="width99" />
				</div>

				<div class="add-new-supply-input-row">
					<label>Tid:</label>
					<input type="text" name="time" value="" class="width99" />
				</div>

			</div>

		<?php
	}

	function save_input_data()
	{
		global $post;
		
		if ( $post )
		{
			update_post_meta($post->ID, "address", @$_POST["address"]);
			update_post_meta($post->ID, "strength", @$_POST["strength"]);
			update_post_meta($post->ID, "phone", @$_POST["phone"]);
		}
	}
}
